<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Admin\AdvertisementRate;
use App\Models\Admin\Website;
use Illuminate\Http\Request;

class AdvertisementRateController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas = AdvertisementRate::oldest()->get();
        $website = Website::latest()->first();
        $title = 'Ads Rate';
        return view('backend.pages.system-setting.advertisement-rate', compact('title', 'datas', 'website'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
   
     public function store(Request $request)
    {
        $request->validate([
            'day' => 'required',
            'cost' => 'required',
        ]);

        $data = new AdvertisementRate();
        $data->day = $request->day;
        $data->cost = $request->cost;
        $data->save();

        return redirect()->back()->with('message','Data added Successfully');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
   
    public function update(Request $request, $id)
    {
        $request->validate([
            'day' => 'required',
            'cost' => 'required',
        ]);
        
        $data = AdvertisementRate::find($id);
        $data->day = $request->day;
        $data->cost = $request->cost;
        $data->save();
    
        return redirect()->back()->with('message', 'Data added Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = AdvertisementRate::find($id);
        $data->delete();

        return redirect()->back()->with('message','Data deleted Successfully');
    }
}
